# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .eco_background_check_package import EcoBackgroundCheckPackage


class BatchUpdateEcoBackgroundCheckPackageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[EcoBackgroundCheckPackage] = None

    @staticmethod
    def builder() -> "BatchUpdateEcoBackgroundCheckPackageRequestBuilder":
        return BatchUpdateEcoBackgroundCheckPackageRequestBuilder()


class BatchUpdateEcoBackgroundCheckPackageRequestBuilder(object):

    def __init__(self) -> None:
        batch_update_eco_background_check_package_request = BatchUpdateEcoBackgroundCheckPackageRequest()
        batch_update_eco_background_check_package_request.http_method = HttpMethod.PATCH
        batch_update_eco_background_check_package_request.uri = "/open-apis/hire/v1/eco_background_check_packages/batch_update"
        batch_update_eco_background_check_package_request.token_types = {AccessTokenType.TENANT}
        self._batch_update_eco_background_check_package_request: BatchUpdateEcoBackgroundCheckPackageRequest = batch_update_eco_background_check_package_request

    def request_body(self,
                     request_body: EcoBackgroundCheckPackage) -> "BatchUpdateEcoBackgroundCheckPackageRequestBuilder":
        self._batch_update_eco_background_check_package_request.request_body = request_body
        self._batch_update_eco_background_check_package_request.body = request_body
        return self

    def build(self) -> BatchUpdateEcoBackgroundCheckPackageRequest:
        return self._batch_update_eco_background_check_package_request
