# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .cancel_eco_background_check_request_body import CancelEcoBackgroundCheckRequestBody


class CancelEcoBackgroundCheckRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[CancelEcoBackgroundCheckRequestBody] = None

    @staticmethod
    def builder() -> "CancelEcoBackgroundCheckRequestBuilder":
        return CancelEcoBackgroundCheckRequestBuilder()


class CancelEcoBackgroundCheckRequestBuilder(object):

    def __init__(self) -> None:
        cancel_eco_background_check_request = CancelEcoBackgroundCheckRequest()
        cancel_eco_background_check_request.http_method = HttpMethod.POST
        cancel_eco_background_check_request.uri = "/open-apis/hire/v1/eco_background_checks/cancel"
        cancel_eco_background_check_request.token_types = {AccessTokenType.TENANT}
        self._cancel_eco_background_check_request: CancelEcoBackgroundCheckRequest = cancel_eco_background_check_request

    def request_body(self,
                     request_body: CancelEcoBackgroundCheckRequestBody) -> "CancelEcoBackgroundCheckRequestBuilder":
        self._cancel_eco_background_check_request.request_body = request_body
        self._cancel_eco_background_check_request.body = request_body
        return self

    def build(self) -> CancelEcoBackgroundCheckRequest:
        return self._cancel_eco_background_check_request
