# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .eco_background_check_custom_field import EcoBackgroundCheckCustomField


class CreateEcoBackgroundCheckCustomFieldRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[EcoBackgroundCheckCustomField] = None

    @staticmethod
    def builder() -> "CreateEcoBackgroundCheckCustomFieldRequestBuilder":
        return CreateEcoBackgroundCheckCustomFieldRequestBuilder()


class CreateEcoBackgroundCheckCustomFieldRequestBuilder(object):

    def __init__(self) -> None:
        create_eco_background_check_custom_field_request = CreateEcoBackgroundCheckCustomFieldRequest()
        create_eco_background_check_custom_field_request.http_method = HttpMethod.POST
        create_eco_background_check_custom_field_request.uri = "/open-apis/hire/v1/eco_background_check_custom_fields"
        create_eco_background_check_custom_field_request.token_types = {AccessTokenType.TENANT}
        self._create_eco_background_check_custom_field_request: CreateEcoBackgroundCheckCustomFieldRequest = create_eco_background_check_custom_field_request

    def request_body(self,
                     request_body: EcoBackgroundCheckCustomField) -> "CreateEcoBackgroundCheckCustomFieldRequestBuilder":
        self._create_eco_background_check_custom_field_request.request_body = request_body
        self._create_eco_background_check_custom_field_request.body = request_body
        return self

    def build(self) -> CreateEcoBackgroundCheckCustomFieldRequest:
        return self._create_eco_background_check_custom_field_request
