# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .eco_background_check_package import EcoBackgroundCheckPackage


class CreateEcoBackgroundCheckPackageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[EcoBackgroundCheckPackage] = None

    @staticmethod
    def builder() -> "CreateEcoBackgroundCheckPackageRequestBuilder":
        return CreateEcoBackgroundCheckPackageRequestBuilder()


class CreateEcoBackgroundCheckPackageRequestBuilder(object):

    def __init__(self) -> None:
        create_eco_background_check_package_request = CreateEcoBackgroundCheckPackageRequest()
        create_eco_background_check_package_request.http_method = HttpMethod.POST
        create_eco_background_check_package_request.uri = "/open-apis/hire/v1/eco_background_check_packages"
        create_eco_background_check_package_request.token_types = {AccessTokenType.TENANT}
        self._create_eco_background_check_package_request: CreateEcoBackgroundCheckPackageRequest = create_eco_background_check_package_request

    def request_body(self, request_body: EcoBackgroundCheckPackage) -> "CreateEcoBackgroundCheckPackageRequestBuilder":
        self._create_eco_background_check_package_request.request_body = request_body
        self._create_eco_background_check_package_request.body = request_body
        return self

    def build(self) -> CreateEcoBackgroundCheckPackageRequest:
        return self._create_eco_background_check_package_request
