# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .job_requirement import JobRequirement


class CreateJobRequirementRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.department_id_type: Optional[str] = None
        self.job_level_id_type: Optional[str] = None
        self.job_family_id_type: Optional[str] = None
        self.employee_type_id_type: Optional[str] = None
        self.request_body: Optional[JobRequirement] = None

    @staticmethod
    def builder() -> "CreateJobRequirementRequestBuilder":
        return CreateJobRequirementRequestBuilder()


class CreateJobRequirementRequestBuilder(object):

    def __init__(self) -> None:
        create_job_requirement_request = CreateJobRequirementRequest()
        create_job_requirement_request.http_method = HttpMethod.POST
        create_job_requirement_request.uri = "/open-apis/hire/v1/job_requirements"
        create_job_requirement_request.token_types = {AccessTokenType.TENANT}
        self._create_job_requirement_request: CreateJobRequirementRequest = create_job_requirement_request

    def user_id_type(self, user_id_type: str) -> "CreateJobRequirementRequestBuilder":
        self._create_job_requirement_request.user_id_type = user_id_type
        self._create_job_requirement_request.add_query("user_id_type", user_id_type)
        return self

    def department_id_type(self, department_id_type: str) -> "CreateJobRequirementRequestBuilder":
        self._create_job_requirement_request.department_id_type = department_id_type
        self._create_job_requirement_request.add_query("department_id_type", department_id_type)
        return self

    def job_level_id_type(self, job_level_id_type: str) -> "CreateJobRequirementRequestBuilder":
        self._create_job_requirement_request.job_level_id_type = job_level_id_type
        self._create_job_requirement_request.add_query("job_level_id_type", job_level_id_type)
        return self

    def job_family_id_type(self, job_family_id_type: str) -> "CreateJobRequirementRequestBuilder":
        self._create_job_requirement_request.job_family_id_type = job_family_id_type
        self._create_job_requirement_request.add_query("job_family_id_type", job_family_id_type)
        return self

    def employee_type_id_type(self, employee_type_id_type: str) -> "CreateJobRequirementRequestBuilder":
        self._create_job_requirement_request.employee_type_id_type = employee_type_id_type
        self._create_job_requirement_request.add_query("employee_type_id_type", employee_type_id_type)
        return self

    def request_body(self, request_body: JobRequirement) -> "CreateJobRequirementRequestBuilder":
        self._create_job_requirement_request.request_body = request_body
        self._create_job_requirement_request.body = request_body
        return self

    def build(self) -> CreateJobRequirementRequest:
        return self._create_job_requirement_request
