# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_referral_account_request_body import CreateReferralAccountRequestBody


class CreateReferralAccountRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[CreateReferralAccountRequestBody] = None

    @staticmethod
    def builder() -> "CreateReferralAccountRequestBuilder":
        return CreateReferralAccountRequestBuilder()


class CreateReferralAccountRequestBuilder(object):

    def __init__(self) -> None:
        create_referral_account_request = CreateReferralAccountRequest()
        create_referral_account_request.http_method = HttpMethod.POST
        create_referral_account_request.uri = "/open-apis/hire/v1/referral_account"
        create_referral_account_request.token_types = {AccessTokenType.TENANT}
        self._create_referral_account_request: CreateReferralAccountRequest = create_referral_account_request

    def request_body(self, request_body: CreateReferralAccountRequestBody) -> "CreateReferralAccountRequestBuilder":
        self._create_referral_account_request.request_body = request_body
        self._create_referral_account_request.body = request_body
        return self

    def build(self) -> CreateReferralAccountRequest:
        return self._create_referral_account_request
