# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeactivateReferralAccountRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.referral_account_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeactivateReferralAccountRequestBuilder":
        return DeactivateReferralAccountRequestBuilder()


class DeactivateReferralAccountRequestBuilder(object):

    def __init__(self) -> None:
        deactivate_referral_account_request = DeactivateReferralAccountRequest()
        deactivate_referral_account_request.http_method = HttpMethod.POST
        deactivate_referral_account_request.uri = "/open-apis/hire/v1/referral_account/:referral_account_id/deactivate"
        deactivate_referral_account_request.token_types = {AccessTokenType.TENANT}
        self._deactivate_referral_account_request: DeactivateReferralAccountRequest = deactivate_referral_account_request

    def referral_account_id(self, referral_account_id: str) -> "DeactivateReferralAccountRequestBuilder":
        self._deactivate_referral_account_request.referral_account_id = referral_account_id
        self._deactivate_referral_account_request.paths["referral_account_id"] = str(referral_account_id)
        return self

    def build(self) -> DeactivateReferralAccountRequest:
        return self._deactivate_referral_account_request
