# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteExternalApplicationRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.talent_id: Optional[str] = None
        self.external_application_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteExternalApplicationRequestBuilder":
        return DeleteExternalApplicationRequestBuilder()


class DeleteExternalApplicationRequestBuilder(object):

    def __init__(self) -> None:
        delete_external_application_request = DeleteExternalApplicationRequest()
        delete_external_application_request.http_method = HttpMethod.DELETE
        delete_external_application_request.uri = "/open-apis/hire/v1/external_applications/:external_application_id"
        delete_external_application_request.token_types = {AccessTokenType.TENANT}
        self._delete_external_application_request: DeleteExternalApplicationRequest = delete_external_application_request

    def talent_id(self, talent_id: str) -> "DeleteExternalApplicationRequestBuilder":
        self._delete_external_application_request.talent_id = talent_id
        self._delete_external_application_request.add_query("talent_id", talent_id)
        return self

    def external_application_id(self, external_application_id: str) -> "DeleteExternalApplicationRequestBuilder":
        self._delete_external_application_request.external_application_id = external_application_id
        self._delete_external_application_request.paths["external_application_id"] = str(external_application_id)
        return self

    def build(self) -> DeleteExternalApplicationRequest:
        return self._delete_external_application_request
