# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .object_attribute import ObjectAttribute


class DiData(object):
    _types = {
        "value": str,
        "object_attribute": ObjectAttribute,
    }

    def __init__(self, d=None):
        self.value: Optional[str] = None
        self.object_attribute: Optional[ObjectAttribute] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DiDataBuilder":
        return DiDataBuilder()


class DiDataBuilder(object):
    def __init__(self) -> None:
        self._di_data = DiData()

    def value(self, value: str) -> "DiDataBuilder":
        self._di_data.value = value
        return self

    def object_attribute(self, object_attribute: ObjectAttribute) -> "DiDataBuilder":
        self._di_data.object_attribute = object_attribute
        return self

    def build(self) -> "DiData":
        return self._di_data
