# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .eco_background_check_custom_field_data_option import EcoBackgroundCheckCustomFieldDataOption
from .i18n import I18n


class EcoBackgroundCheckCustomFieldData(object):
    _types = {
        "type": str,
        "key": str,
        "name": I18n,
        "is_required": bool,
        "description": I18n,
        "options": List[EcoBackgroundCheckCustomFieldDataOption],
    }

    def __init__(self, d=None):
        self.type: Optional[str] = None
        self.key: Optional[str] = None
        self.name: Optional[I18n] = None
        self.is_required: Optional[bool] = None
        self.description: Optional[I18n] = None
        self.options: Optional[List[EcoBackgroundCheckCustomFieldDataOption]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EcoBackgroundCheckCustomFieldDataBuilder":
        return EcoBackgroundCheckCustomFieldDataBuilder()


class EcoBackgroundCheckCustomFieldDataBuilder(object):
    def __init__(self) -> None:
        self._eco_background_check_custom_field_data = EcoBackgroundCheckCustomFieldData()

    def type(self, type: str) -> "EcoBackgroundCheckCustomFieldDataBuilder":
        self._eco_background_check_custom_field_data.type = type
        return self

    def key(self, key: str) -> "EcoBackgroundCheckCustomFieldDataBuilder":
        self._eco_background_check_custom_field_data.key = key
        return self

    def name(self, name: I18n) -> "EcoBackgroundCheckCustomFieldDataBuilder":
        self._eco_background_check_custom_field_data.name = name
        return self

    def is_required(self, is_required: bool) -> "EcoBackgroundCheckCustomFieldDataBuilder":
        self._eco_background_check_custom_field_data.is_required = is_required
        return self

    def description(self, description: I18n) -> "EcoBackgroundCheckCustomFieldDataBuilder":
        self._eco_background_check_custom_field_data.description = description
        return self

    def options(self,
                options: List[EcoBackgroundCheckCustomFieldDataOption]) -> "EcoBackgroundCheckCustomFieldDataBuilder":
        self._eco_background_check_custom_field_data.options = options
        return self

    def build(self) -> "EcoBackgroundCheckCustomFieldData":
        return self._eco_background_check_custom_field_data
