# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class EcoExamLoginInfo(object):
    _types = {
        "exam_url": str,
        "username": str,
        "password": str,
    }

    def __init__(self, d=None):
        self.exam_url: Optional[str] = None
        self.username: Optional[str] = None
        self.password: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EcoExamLoginInfoBuilder":
        return EcoExamLoginInfoBuilder()


class EcoExamLoginInfoBuilder(object):
    def __init__(self) -> None:
        self._eco_exam_login_info = EcoExamLoginInfo()

    def exam_url(self, exam_url: str) -> "EcoExamLoginInfoBuilder":
        self._eco_exam_login_info.exam_url = exam_url
        return self

    def username(self, username: str) -> "EcoExamLoginInfoBuilder":
        self._eco_exam_login_info.username = username
        return self

    def password(self, password: str) -> "EcoExamLoginInfoBuilder":
        self._eco_exam_login_info.password = password
        return self

    def build(self) -> "EcoExamLoginInfo":
        return self._eco_exam_login_info
