# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class EcoExamPaperData(object):
    _types = {
        "id": str,
        "name": str,
        "duration": int,
        "question_count": int,
        "start_time": str,
        "end_time": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.duration: Optional[int] = None
        self.question_count: Optional[int] = None
        self.start_time: Optional[str] = None
        self.end_time: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EcoExamPaperDataBuilder":
        return EcoExamPaperDataBuilder()


class EcoExamPaperDataBuilder(object):
    def __init__(self) -> None:
        self._eco_exam_paper_data = EcoExamPaperData()

    def id(self, id: str) -> "EcoExamPaperDataBuilder":
        self._eco_exam_paper_data.id = id
        return self

    def name(self, name: str) -> "EcoExamPaperDataBuilder":
        self._eco_exam_paper_data.name = name
        return self

    def duration(self, duration: int) -> "EcoExamPaperDataBuilder":
        self._eco_exam_paper_data.duration = duration
        return self

    def question_count(self, question_count: int) -> "EcoExamPaperDataBuilder":
        self._eco_exam_paper_data.question_count = question_count
        return self

    def start_time(self, start_time: str) -> "EcoExamPaperDataBuilder":
        self._eco_exam_paper_data.start_time = start_time
        return self

    def end_time(self, end_time: str) -> "EcoExamPaperDataBuilder":
        self._eco_exam_paper_data.end_time = end_time
        return self

    def build(self) -> "EcoExamPaperData":
        return self._eco_exam_paper_data
