# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .eco_exam_result_detail import EcoExamResultDetail
from .eco_exam_result_report import EcoExamResultReport


class EcoExamResult(object):
    _types = {
        "result": str,
        "result_time": str,
        "report_list": List[EcoExamResultReport],
        "detail_list": List[EcoExamResultDetail],
    }

    def __init__(self, d=None):
        self.result: Optional[str] = None
        self.result_time: Optional[str] = None
        self.report_list: Optional[List[EcoExamResultReport]] = None
        self.detail_list: Optional[List[EcoExamResultDetail]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EcoExamResultBuilder":
        return EcoExamResultBuilder()


class EcoExamResultBuilder(object):
    def __init__(self) -> None:
        self._eco_exam_result = EcoExamResult()

    def result(self, result: str) -> "EcoExamResultBuilder":
        self._eco_exam_result.result = result
        return self

    def result_time(self, result_time: str) -> "EcoExamResultBuilder":
        self._eco_exam_result.result_time = result_time
        return self

    def report_list(self, report_list: List[EcoExamResultReport]) -> "EcoExamResultBuilder":
        self._eco_exam_result.report_list = report_list
        return self

    def detail_list(self, detail_list: List[EcoExamResultDetail]) -> "EcoExamResultBuilder":
        self._eco_exam_result.detail_list = detail_list
        return self

    def build(self) -> "EcoExamResult":
        return self._eco_exam_result
