# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class EducationInfo(object):
    _types = {
        "degree": int,
        "end_time": int,
        "field_of_study": str,
        "school": str,
        "start_time": int,
        "education_type": int,
        "academic_ranking": int,
    }

    def __init__(self, d=None):
        self.degree: Optional[int] = None
        self.end_time: Optional[int] = None
        self.field_of_study: Optional[str] = None
        self.school: Optional[str] = None
        self.start_time: Optional[int] = None
        self.education_type: Optional[int] = None
        self.academic_ranking: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EducationInfoBuilder":
        return EducationInfoBuilder()


class EducationInfoBuilder(object):
    def __init__(self) -> None:
        self._education_info = EducationInfo()

    def degree(self, degree: int) -> "EducationInfoBuilder":
        self._education_info.degree = degree
        return self

    def end_time(self, end_time: int) -> "EducationInfoBuilder":
        self._education_info.end_time = end_time
        return self

    def field_of_study(self, field_of_study: str) -> "EducationInfoBuilder":
        self._education_info.field_of_study = field_of_study
        return self

    def school(self, school: str) -> "EducationInfoBuilder":
        self._education_info.school = school
        return self

    def start_time(self, start_time: int) -> "EducationInfoBuilder":
        self._education_info.start_time = start_time
        return self

    def education_type(self, education_type: int) -> "EducationInfoBuilder":
        self._education_info.education_type = education_type
        return self

    def academic_ranking(self, academic_ranking: int) -> "EducationInfoBuilder":
        self._education_info.academic_ranking = academic_ranking
        return self

    def build(self) -> "EducationInfo":
        return self._education_info
