# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class EmployeeOverboardInfo(object):
    _types = {
        "actual_overboard_time": int,
        "overboard_note": str,
    }

    def __init__(self, d=None):
        self.actual_overboard_time: Optional[int] = None
        self.overboard_note: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EmployeeOverboardInfoBuilder":
        return EmployeeOverboardInfoBuilder()


class EmployeeOverboardInfoBuilder(object):
    def __init__(self) -> None:
        self._employee_overboard_info = EmployeeOverboardInfo()

    def actual_overboard_time(self, actual_overboard_time: int) -> "EmployeeOverboardInfoBuilder":
        self._employee_overboard_info.actual_overboard_time = actual_overboard_time
        return self

    def overboard_note(self, overboard_note: str) -> "EmployeeOverboardInfoBuilder":
        self._employee_overboard_info.overboard_note = overboard_note
        return self

    def build(self) -> "EmployeeOverboardInfo":
        return self._employee_overboard_info
