# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Evaluation(object):
    _types = {
        "id": str,
        "application_id": str,
        "stage_id": str,
        "creator_id": str,
        "evaluator_id": str,
        "commit_status": int,
        "conclusion": int,
        "content": str,
        "create_time": str,
        "update_time": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.application_id: Optional[str] = None
        self.stage_id: Optional[str] = None
        self.creator_id: Optional[str] = None
        self.evaluator_id: Optional[str] = None
        self.commit_status: Optional[int] = None
        self.conclusion: Optional[int] = None
        self.content: Optional[str] = None
        self.create_time: Optional[str] = None
        self.update_time: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EvaluationBuilder":
        return EvaluationBuilder()


class EvaluationBuilder(object):
    def __init__(self) -> None:
        self._evaluation = Evaluation()

    def id(self, id: str) -> "EvaluationBuilder":
        self._evaluation.id = id
        return self

    def application_id(self, application_id: str) -> "EvaluationBuilder":
        self._evaluation.application_id = application_id
        return self

    def stage_id(self, stage_id: str) -> "EvaluationBuilder":
        self._evaluation.stage_id = stage_id
        return self

    def creator_id(self, creator_id: str) -> "EvaluationBuilder":
        self._evaluation.creator_id = creator_id
        return self

    def evaluator_id(self, evaluator_id: str) -> "EvaluationBuilder":
        self._evaluation.evaluator_id = evaluator_id
        return self

    def commit_status(self, commit_status: int) -> "EvaluationBuilder":
        self._evaluation.commit_status = commit_status
        return self

    def conclusion(self, conclusion: int) -> "EvaluationBuilder":
        self._evaluation.conclusion = conclusion
        return self

    def content(self, content: str) -> "EvaluationBuilder":
        self._evaluation.content = content
        return self

    def create_time(self, create_time: str) -> "EvaluationBuilder":
        self._evaluation.create_time = create_time
        return self

    def update_time(self, update_time: str) -> "EvaluationBuilder":
        self._evaluation.update_time = update_time
        return self

    def build(self) -> "Evaluation":
        return self._evaluation
