# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .external_background_check_attachment import ExternalBackgroundCheckAttachment


class ExternalBackgroundCheck(object):
    _types = {
        "id": str,
        "external_id": str,
        "external_application_id": str,
        "date": int,
        "name": str,
        "result": str,
        "attachment_id_list": List[str],
        "attachment_list": List[ExternalBackgroundCheckAttachment],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.external_id: Optional[str] = None
        self.external_application_id: Optional[str] = None
        self.date: Optional[int] = None
        self.name: Optional[str] = None
        self.result: Optional[str] = None
        self.attachment_id_list: Optional[List[str]] = None
        self.attachment_list: Optional[List[ExternalBackgroundCheckAttachment]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ExternalBackgroundCheckBuilder":
        return ExternalBackgroundCheckBuilder()


class ExternalBackgroundCheckBuilder(object):
    def __init__(self) -> None:
        self._external_background_check = ExternalBackgroundCheck()

    def id(self, id: str) -> "ExternalBackgroundCheckBuilder":
        self._external_background_check.id = id
        return self

    def external_id(self, external_id: str) -> "ExternalBackgroundCheckBuilder":
        self._external_background_check.external_id = external_id
        return self

    def external_application_id(self, external_application_id: str) -> "ExternalBackgroundCheckBuilder":
        self._external_background_check.external_application_id = external_application_id
        return self

    def date(self, date: int) -> "ExternalBackgroundCheckBuilder":
        self._external_background_check.date = date
        return self

    def name(self, name: str) -> "ExternalBackgroundCheckBuilder":
        self._external_background_check.name = name
        return self

    def result(self, result: str) -> "ExternalBackgroundCheckBuilder":
        self._external_background_check.result = result
        return self

    def attachment_id_list(self, attachment_id_list: List[str]) -> "ExternalBackgroundCheckBuilder":
        self._external_background_check.attachment_id_list = attachment_id_list
        return self

    def attachment_list(self,
                        attachment_list: List[ExternalBackgroundCheckAttachment]) -> "ExternalBackgroundCheckBuilder":
        self._external_background_check.attachment_list = attachment_list
        return self

    def build(self) -> "ExternalBackgroundCheck":
        return self._external_background_check
