# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ExternalInterview(object):
    _types = {
        "external_id": str,
        "external_application_id": str,
        "id": str,
        "participate_status": int,
        "begin_time": int,
        "end_time": int,
    }

    def __init__(self, d=None):
        self.external_id: Optional[str] = None
        self.external_application_id: Optional[str] = None
        self.id: Optional[str] = None
        self.participate_status: Optional[int] = None
        self.begin_time: Optional[int] = None
        self.end_time: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ExternalInterviewBuilder":
        return ExternalInterviewBuilder()


class ExternalInterviewBuilder(object):
    def __init__(self) -> None:
        self._external_interview = ExternalInterview()

    def external_id(self, external_id: str) -> "ExternalInterviewBuilder":
        self._external_interview.external_id = external_id
        return self

    def external_application_id(self, external_application_id: str) -> "ExternalInterviewBuilder":
        self._external_interview.external_application_id = external_application_id
        return self

    def id(self, id: str) -> "ExternalInterviewBuilder":
        self._external_interview.id = id
        return self

    def participate_status(self, participate_status: int) -> "ExternalInterviewBuilder":
        self._external_interview.participate_status = participate_status
        return self

    def begin_time(self, begin_time: int) -> "ExternalInterviewBuilder":
        self._external_interview.begin_time = begin_time
        return self

    def end_time(self, end_time: int) -> "ExternalInterviewBuilder":
        self._external_interview.end_time = end_time
        return self

    def build(self) -> "ExternalInterview":
        return self._external_interview
