# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .bonus_amount import BonusAmount


class ExternalReward(object):
    _types = {
        "referral_user_id": str,
        "create_user_id": str,
        "confirm_user_id": str,
        "pay_user_id": str,
        "external_id": str,
        "application_id": str,
        "talent_id": str,
        "job_id": str,
        "reason": str,
        "rule_type": int,
        "bonus": BonusAmount,
        "stage": int,
        "create_time": str,
        "confirm_time": str,
        "pay_time": str,
        "onboard_time": str,
        "conversion_time": str,
        "comment": str,
    }

    def __init__(self, d=None):
        self.referral_user_id: Optional[str] = None
        self.create_user_id: Optional[str] = None
        self.confirm_user_id: Optional[str] = None
        self.pay_user_id: Optional[str] = None
        self.external_id: Optional[str] = None
        self.application_id: Optional[str] = None
        self.talent_id: Optional[str] = None
        self.job_id: Optional[str] = None
        self.reason: Optional[str] = None
        self.rule_type: Optional[int] = None
        self.bonus: Optional[BonusAmount] = None
        self.stage: Optional[int] = None
        self.create_time: Optional[str] = None
        self.confirm_time: Optional[str] = None
        self.pay_time: Optional[str] = None
        self.onboard_time: Optional[str] = None
        self.conversion_time: Optional[str] = None
        self.comment: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ExternalRewardBuilder":
        return ExternalRewardBuilder()


class ExternalRewardBuilder(object):
    def __init__(self) -> None:
        self._external_reward = ExternalReward()

    def referral_user_id(self, referral_user_id: str) -> "ExternalRewardBuilder":
        self._external_reward.referral_user_id = referral_user_id
        return self

    def create_user_id(self, create_user_id: str) -> "ExternalRewardBuilder":
        self._external_reward.create_user_id = create_user_id
        return self

    def confirm_user_id(self, confirm_user_id: str) -> "ExternalRewardBuilder":
        self._external_reward.confirm_user_id = confirm_user_id
        return self

    def pay_user_id(self, pay_user_id: str) -> "ExternalRewardBuilder":
        self._external_reward.pay_user_id = pay_user_id
        return self

    def external_id(self, external_id: str) -> "ExternalRewardBuilder":
        self._external_reward.external_id = external_id
        return self

    def application_id(self, application_id: str) -> "ExternalRewardBuilder":
        self._external_reward.application_id = application_id
        return self

    def talent_id(self, talent_id: str) -> "ExternalRewardBuilder":
        self._external_reward.talent_id = talent_id
        return self

    def job_id(self, job_id: str) -> "ExternalRewardBuilder":
        self._external_reward.job_id = job_id
        return self

    def reason(self, reason: str) -> "ExternalRewardBuilder":
        self._external_reward.reason = reason
        return self

    def rule_type(self, rule_type: int) -> "ExternalRewardBuilder":
        self._external_reward.rule_type = rule_type
        return self

    def bonus(self, bonus: BonusAmount) -> "ExternalRewardBuilder":
        self._external_reward.bonus = bonus
        return self

    def stage(self, stage: int) -> "ExternalRewardBuilder":
        self._external_reward.stage = stage
        return self

    def create_time(self, create_time: str) -> "ExternalRewardBuilder":
        self._external_reward.create_time = create_time
        return self

    def confirm_time(self, confirm_time: str) -> "ExternalRewardBuilder":
        self._external_reward.confirm_time = confirm_time
        return self

    def pay_time(self, pay_time: str) -> "ExternalRewardBuilder":
        self._external_reward.pay_time = pay_time
        return self

    def onboard_time(self, onboard_time: str) -> "ExternalRewardBuilder":
        self._external_reward.onboard_time = onboard_time
        return self

    def conversion_time(self, conversion_time: str) -> "ExternalRewardBuilder":
        self._external_reward.conversion_time = conversion_time
        return self

    def comment(self, comment: str) -> "ExternalRewardBuilder":
        self._external_reward.comment = comment
        return self

    def build(self) -> "ExternalReward":
        return self._external_reward
