# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetByApplicationEmployeeRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.application_id: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.department_id_type: Optional[str] = None
        self.job_level_id_type: Optional[str] = None
        self.job_family_id_type: Optional[str] = None
        self.employee_type_id_type: Optional[str] = None

    @staticmethod
    def builder() -> "GetByApplicationEmployeeRequestBuilder":
        return GetByApplicationEmployeeRequestBuilder()


class GetByApplicationEmployeeRequestBuilder(object):

    def __init__(self) -> None:
        get_by_application_employee_request = GetByApplicationEmployeeRequest()
        get_by_application_employee_request.http_method = HttpMethod.GET
        get_by_application_employee_request.uri = "/open-apis/hire/v1/employees/get_by_application"
        get_by_application_employee_request.token_types = {AccessTokenType.TENANT}
        self._get_by_application_employee_request: GetByApplicationEmployeeRequest = get_by_application_employee_request

    def application_id(self, application_id: str) -> "GetByApplicationEmployeeRequestBuilder":
        self._get_by_application_employee_request.application_id = application_id
        self._get_by_application_employee_request.add_query("application_id", application_id)
        return self

    def user_id_type(self, user_id_type: str) -> "GetByApplicationEmployeeRequestBuilder":
        self._get_by_application_employee_request.user_id_type = user_id_type
        self._get_by_application_employee_request.add_query("user_id_type", user_id_type)
        return self

    def department_id_type(self, department_id_type: str) -> "GetByApplicationEmployeeRequestBuilder":
        self._get_by_application_employee_request.department_id_type = department_id_type
        self._get_by_application_employee_request.add_query("department_id_type", department_id_type)
        return self

    def job_level_id_type(self, job_level_id_type: str) -> "GetByApplicationEmployeeRequestBuilder":
        self._get_by_application_employee_request.job_level_id_type = job_level_id_type
        self._get_by_application_employee_request.add_query("job_level_id_type", job_level_id_type)
        return self

    def job_family_id_type(self, job_family_id_type: str) -> "GetByApplicationEmployeeRequestBuilder":
        self._get_by_application_employee_request.job_family_id_type = job_family_id_type
        self._get_by_application_employee_request.add_query("job_family_id_type", job_family_id_type)
        return self

    def employee_type_id_type(self, employee_type_id_type: str) -> "GetByApplicationEmployeeRequestBuilder":
        self._get_by_application_employee_request.employee_type_id_type = employee_type_id_type
        self._get_by_application_employee_request.add_query("employee_type_id_type", employee_type_id_type)
        return self

    def build(self) -> GetByApplicationEmployeeRequest:
        return self._get_by_application_employee_request
