# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetJobManagerRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.job_id: Optional[str] = None
        self.manager_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetJobManagerRequestBuilder":
        return GetJobManagerRequestBuilder()


class GetJobManagerRequestBuilder(object):

    def __init__(self) -> None:
        get_job_manager_request = GetJobManagerRequest()
        get_job_manager_request.http_method = HttpMethod.GET
        get_job_manager_request.uri = "/open-apis/hire/v1/jobs/:job_id/managers/:manager_id"
        get_job_manager_request.token_types = {AccessTokenType.TENANT}
        self._get_job_manager_request: GetJobManagerRequest = get_job_manager_request

    def user_id_type(self, user_id_type: str) -> "GetJobManagerRequestBuilder":
        self._get_job_manager_request.user_id_type = user_id_type
        self._get_job_manager_request.add_query("user_id_type", user_id_type)
        return self

    def job_id(self, job_id: str) -> "GetJobManagerRequestBuilder":
        self._get_job_manager_request.job_id = job_id
        self._get_job_manager_request.paths["job_id"] = str(job_id)
        return self

    def manager_id(self, manager_id: str) -> "GetJobManagerRequestBuilder":
        self._get_job_manager_request.manager_id = manager_id
        self._get_job_manager_request.paths["manager_id"] = str(manager_id)
        return self

    def build(self) -> GetJobManagerRequest:
        return self._get_job_manager_request
