# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetOfferSchemaRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.offer_schema_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetOfferSchemaRequestBuilder":
        return GetOfferSchemaRequestBuilder()


class GetOfferSchemaRequestBuilder(object):

    def __init__(self) -> None:
        get_offer_schema_request = GetOfferSchemaRequest()
        get_offer_schema_request.http_method = HttpMethod.GET
        get_offer_schema_request.uri = "/open-apis/hire/v1/offer_schemas/:offer_schema_id"
        get_offer_schema_request.token_types = {AccessTokenType.TENANT}
        self._get_offer_schema_request: GetOfferSchemaRequest = get_offer_schema_request

    def offer_schema_id(self, offer_schema_id: str) -> "GetOfferSchemaRequestBuilder":
        self._get_offer_schema_request.offer_schema_id = offer_schema_id
        self._get_offer_schema_request.paths["offer_schema_id"] = str(offer_schema_id)
        return self

    def build(self) -> GetOfferSchemaRequest:
        return self._get_offer_schema_request
