# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .i18n import I18n


class IdNameObject(object):
    _types = {
        "id": str,
        "name": I18n,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[I18n] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "IdNameObjectBuilder":
        return IdNameObjectBuilder()


class IdNameObjectBuilder(object):
    def __init__(self) -> None:
        self._id_name_object = IdNameObject()

    def id(self, id: str) -> "IdNameObjectBuilder":
        self._id_name_object.id = id
        return self

    def name(self, name: I18n) -> "IdNameObjectBuilder":
        self._id_name_object.name = name
        return self

    def build(self) -> "IdNameObject":
        return self._id_name_object
