# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .intern_offer_offboarding_info import InternOfferOffboardingInfo
from .intern_offer_onboarding_info import InternOfferOnboardingInfo


class InternOfferStatus(object):
    _types = {
        "offer_id": str,
        "operation": str,
        "onboarding_info": InternOfferOnboardingInfo,
        "offboarding_info": InternOfferOffboardingInfo,
    }

    def __init__(self, d=None):
        self.offer_id: Optional[str] = None
        self.operation: Optional[str] = None
        self.onboarding_info: Optional[InternOfferOnboardingInfo] = None
        self.offboarding_info: Optional[InternOfferOffboardingInfo] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InternOfferStatusBuilder":
        return InternOfferStatusBuilder()


class InternOfferStatusBuilder(object):
    def __init__(self) -> None:
        self._intern_offer_status = InternOfferStatus()

    def offer_id(self, offer_id: str) -> "InternOfferStatusBuilder":
        self._intern_offer_status.offer_id = offer_id
        return self

    def operation(self, operation: str) -> "InternOfferStatusBuilder":
        self._intern_offer_status.operation = operation
        return self

    def onboarding_info(self, onboarding_info: InternOfferOnboardingInfo) -> "InternOfferStatusBuilder":
        self._intern_offer_status.onboarding_info = onboarding_info
        return self

    def offboarding_info(self, offboarding_info: InternOfferOffboardingInfo) -> "InternOfferStatusBuilder":
        self._intern_offer_status.offboarding_info = offboarding_info
        return self

    def build(self) -> "InternOfferStatus":
        return self._intern_offer_status
