# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .intern_offer_status import InternOfferStatus


class InternOfferStatusOfferRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.offer_id: Optional[str] = None
        self.request_body: Optional[InternOfferStatus] = None

    @staticmethod
    def builder() -> "InternOfferStatusOfferRequestBuilder":
        return InternOfferStatusOfferRequestBuilder()


class InternOfferStatusOfferRequestBuilder(object):

    def __init__(self) -> None:
        intern_offer_status_offer_request = InternOfferStatusOfferRequest()
        intern_offer_status_offer_request.http_method = HttpMethod.POST
        intern_offer_status_offer_request.uri = "/open-apis/hire/v1/offers/:offer_id/intern_offer_status"
        intern_offer_status_offer_request.token_types = {AccessTokenType.TENANT}
        self._intern_offer_status_offer_request: InternOfferStatusOfferRequest = intern_offer_status_offer_request

    def offer_id(self, offer_id: str) -> "InternOfferStatusOfferRequestBuilder":
        self._intern_offer_status_offer_request.offer_id = offer_id
        self._intern_offer_status_offer_request.paths["offer_id"] = str(offer_id)
        return self

    def request_body(self, request_body: InternOfferStatus) -> "InternOfferStatusOfferRequestBuilder":
        self._intern_offer_status_offer_request.request_body = request_body
        self._intern_offer_status_offer_request.body = request_body
        return self

    def build(self) -> InternOfferStatusOfferRequest:
        return self._intern_offer_status_offer_request
