# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .intern_offer_offboarding_info import InternOfferOffboardingInfo
from .intern_offer_onboarding_info import InternOfferOnboardingInfo


class InternOfferStatusOfferResponseBody(object):
    _types = {
        "offer_id": str,
        "operation": str,
        "onboarding_info": InternOfferOnboardingInfo,
        "offboarding_info": InternOfferOffboardingInfo,
    }

    def __init__(self, d=None):
        self.offer_id: Optional[str] = None
        self.operation: Optional[str] = None
        self.onboarding_info: Optional[InternOfferOnboardingInfo] = None
        self.offboarding_info: Optional[InternOfferOffboardingInfo] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InternOfferStatusOfferResponseBodyBuilder":
        return InternOfferStatusOfferResponseBodyBuilder()


class InternOfferStatusOfferResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._intern_offer_status_offer_response_body = InternOfferStatusOfferResponseBody()

    def offer_id(self, offer_id: str) -> "InternOfferStatusOfferResponseBodyBuilder":
        self._intern_offer_status_offer_response_body.offer_id = offer_id
        return self

    def operation(self, operation: str) -> "InternOfferStatusOfferResponseBodyBuilder":
        self._intern_offer_status_offer_response_body.operation = operation
        return self

    def onboarding_info(self,
                        onboarding_info: InternOfferOnboardingInfo) -> "InternOfferStatusOfferResponseBodyBuilder":
        self._intern_offer_status_offer_response_body.onboarding_info = onboarding_info
        return self

    def offboarding_info(self,
                         offboarding_info: InternOfferOffboardingInfo) -> "InternOfferStatusOfferResponseBodyBuilder":
        self._intern_offer_status_offer_response_body.offboarding_info = offboarding_info
        return self

    def build(self) -> "InternOfferStatusOfferResponseBody":
        return self._intern_offer_status_offer_response_body
