# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class InternshipInfo(object):
    _types = {
        "career_type": int,
        "company": str,
        "desc": str,
        "end_time": int,
        "start_time": int,
        "title": str,
    }

    def __init__(self, d=None):
        self.career_type: Optional[int] = None
        self.company: Optional[str] = None
        self.desc: Optional[str] = None
        self.end_time: Optional[int] = None
        self.start_time: Optional[int] = None
        self.title: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InternshipInfoBuilder":
        return InternshipInfoBuilder()


class InternshipInfoBuilder(object):
    def __init__(self) -> None:
        self._internship_info = InternshipInfo()

    def career_type(self, career_type: int) -> "InternshipInfoBuilder":
        self._internship_info.career_type = career_type
        return self

    def company(self, company: str) -> "InternshipInfoBuilder":
        self._internship_info.company = company
        return self

    def desc(self, desc: str) -> "InternshipInfoBuilder":
        self._internship_info.desc = desc
        return self

    def end_time(self, end_time: int) -> "InternshipInfoBuilder":
        self._internship_info.end_time = end_time
        return self

    def start_time(self, start_time: int) -> "InternshipInfoBuilder":
        self._internship_info.start_time = start_time
        return self

    def title(self, title: str) -> "InternshipInfoBuilder":
        self._internship_info.title = title
        return self

    def build(self) -> "InternshipInfo":
        return self._internship_info
