# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .interview_appointment_config_content import InterviewAppointmentConfigContent


class InterviewAppointmentConfig(object):
    _types = {
        "enable_interview_appointment_by_interviewer": bool,
        "config": InterviewAppointmentConfigContent,
    }

    def __init__(self, d=None):
        self.enable_interview_appointment_by_interviewer: Optional[bool] = None
        self.config: Optional[InterviewAppointmentConfigContent] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InterviewAppointmentConfigBuilder":
        return InterviewAppointmentConfigBuilder()


class InterviewAppointmentConfigBuilder(object):
    def __init__(self) -> None:
        self._interview_appointment_config = InterviewAppointmentConfig()

    def enable_interview_appointment_by_interviewer(self,
                                                    enable_interview_appointment_by_interviewer: bool) -> "InterviewAppointmentConfigBuilder":
        self._interview_appointment_config.enable_interview_appointment_by_interviewer = enable_interview_appointment_by_interviewer
        return self

    def config(self, config: InterviewAppointmentConfigContent) -> "InterviewAppointmentConfigBuilder":
        self._interview_appointment_config.config = config
        return self

    def build(self) -> "InterviewAppointmentConfig":
        return self._interview_appointment_config
