# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class InterviewAppointmentConfigContent(object):
    _types = {
        "interview_type": int,
        "talent_timezone_code": str,
        "contact_user_id": str,
        "contact_mobile": str,
        "contact_email": str,
        "address_id": str,
        "video_type": int,
        "cc": List[str],
        "remark": str,
        "interview_notification_template_id": str,
        "appointment_notification_template_id": str,
        "cancel_interview_notification_template_id": str,
    }

    def __init__(self, d=None):
        self.interview_type: Optional[int] = None
        self.talent_timezone_code: Optional[str] = None
        self.contact_user_id: Optional[str] = None
        self.contact_mobile: Optional[str] = None
        self.contact_email: Optional[str] = None
        self.address_id: Optional[str] = None
        self.video_type: Optional[int] = None
        self.cc: Optional[List[str]] = None
        self.remark: Optional[str] = None
        self.interview_notification_template_id: Optional[str] = None
        self.appointment_notification_template_id: Optional[str] = None
        self.cancel_interview_notification_template_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InterviewAppointmentConfigContentBuilder":
        return InterviewAppointmentConfigContentBuilder()


class InterviewAppointmentConfigContentBuilder(object):
    def __init__(self) -> None:
        self._interview_appointment_config_content = InterviewAppointmentConfigContent()

    def interview_type(self, interview_type: int) -> "InterviewAppointmentConfigContentBuilder":
        self._interview_appointment_config_content.interview_type = interview_type
        return self

    def talent_timezone_code(self, talent_timezone_code: str) -> "InterviewAppointmentConfigContentBuilder":
        self._interview_appointment_config_content.talent_timezone_code = talent_timezone_code
        return self

    def contact_user_id(self, contact_user_id: str) -> "InterviewAppointmentConfigContentBuilder":
        self._interview_appointment_config_content.contact_user_id = contact_user_id
        return self

    def contact_mobile(self, contact_mobile: str) -> "InterviewAppointmentConfigContentBuilder":
        self._interview_appointment_config_content.contact_mobile = contact_mobile
        return self

    def contact_email(self, contact_email: str) -> "InterviewAppointmentConfigContentBuilder":
        self._interview_appointment_config_content.contact_email = contact_email
        return self

    def address_id(self, address_id: str) -> "InterviewAppointmentConfigContentBuilder":
        self._interview_appointment_config_content.address_id = address_id
        return self

    def video_type(self, video_type: int) -> "InterviewAppointmentConfigContentBuilder":
        self._interview_appointment_config_content.video_type = video_type
        return self

    def cc(self, cc: List[str]) -> "InterviewAppointmentConfigContentBuilder":
        self._interview_appointment_config_content.cc = cc
        return self

    def remark(self, remark: str) -> "InterviewAppointmentConfigContentBuilder":
        self._interview_appointment_config_content.remark = remark
        return self

    def interview_notification_template_id(self,
                                           interview_notification_template_id: str) -> "InterviewAppointmentConfigContentBuilder":
        self._interview_appointment_config_content.interview_notification_template_id = interview_notification_template_id
        return self

    def appointment_notification_template_id(self,
                                             appointment_notification_template_id: str) -> "InterviewAppointmentConfigContentBuilder":
        self._interview_appointment_config_content.appointment_notification_template_id = appointment_notification_template_id
        return self

    def cancel_interview_notification_template_id(self,
                                                  cancel_interview_notification_template_id: str) -> "InterviewAppointmentConfigContentBuilder":
        self._interview_appointment_config_content.cancel_interview_notification_template_id = cancel_interview_notification_template_id
        return self

    def build(self) -> "InterviewAppointmentConfigContent":
        return self._interview_appointment_config_content
