# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .i18n import I18n


class InterviewDimensionScore(object):
    _types = {
        "id": str,
        "name": I18n,
        "score_val": int,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[I18n] = None
        self.score_val: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InterviewDimensionScoreBuilder":
        return InterviewDimensionScoreBuilder()


class InterviewDimensionScoreBuilder(object):
    def __init__(self) -> None:
        self._interview_dimension_score = InterviewDimensionScore()

    def id(self, id: str) -> "InterviewDimensionScoreBuilder":
        self._interview_dimension_score.id = id
        return self

    def name(self, name: I18n) -> "InterviewDimensionScoreBuilder":
        self._interview_dimension_score.name = name
        return self

    def score_val(self, score_val: int) -> "InterviewDimensionScoreBuilder":
        self._interview_dimension_score.score_val = score_val
        return self

    def build(self) -> "InterviewDimensionScore":
        return self._interview_dimension_score
