# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class InterviewMeetingRoom(object):
    _types = {
        "room_id": str,
        "room_name": str,
        "building_name": str,
        "reserved_status": int,
        "floor_name": str,
    }

    def __init__(self, d=None):
        self.room_id: Optional[str] = None
        self.room_name: Optional[str] = None
        self.building_name: Optional[str] = None
        self.reserved_status: Optional[int] = None
        self.floor_name: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InterviewMeetingRoomBuilder":
        return InterviewMeetingRoomBuilder()


class InterviewMeetingRoomBuilder(object):
    def __init__(self) -> None:
        self._interview_meeting_room = InterviewMeetingRoom()

    def room_id(self, room_id: str) -> "InterviewMeetingRoomBuilder":
        self._interview_meeting_room.room_id = room_id
        return self

    def room_name(self, room_name: str) -> "InterviewMeetingRoomBuilder":
        self._interview_meeting_room.room_name = room_name
        return self

    def building_name(self, building_name: str) -> "InterviewMeetingRoomBuilder":
        self._interview_meeting_room.building_name = building_name
        return self

    def reserved_status(self, reserved_status: int) -> "InterviewMeetingRoomBuilder":
        self._interview_meeting_room.reserved_status = reserved_status
        return self

    def floor_name(self, floor_name: str) -> "InterviewMeetingRoomBuilder":
        self._interview_meeting_room.floor_name = floor_name
        return self

    def build(self) -> "InterviewMeetingRoom":
        return self._interview_meeting_room
