# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .common_schema import CommonSchema


class InterviewRegistrationSchema(object):
    _types = {
        "id": str,
        "name": str,
        "is_used_as_interview": bool,
        "object_list": List[CommonSchema],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.is_used_as_interview: Optional[bool] = None
        self.object_list: Optional[List[CommonSchema]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InterviewRegistrationSchemaBuilder":
        return InterviewRegistrationSchemaBuilder()


class InterviewRegistrationSchemaBuilder(object):
    def __init__(self) -> None:
        self._interview_registration_schema = InterviewRegistrationSchema()

    def id(self, id: str) -> "InterviewRegistrationSchemaBuilder":
        self._interview_registration_schema.id = id
        return self

    def name(self, name: str) -> "InterviewRegistrationSchemaBuilder":
        self._interview_registration_schema.name = name
        return self

    def is_used_as_interview(self, is_used_as_interview: bool) -> "InterviewRegistrationSchemaBuilder":
        self._interview_registration_schema.is_used_as_interview = is_used_as_interview
        return self

    def object_list(self, object_list: List[CommonSchema]) -> "InterviewRegistrationSchemaBuilder":
        self._interview_registration_schema.object_list = object_list
        return self

    def build(self) -> "InterviewRegistrationSchema":
        return self._interview_registration_schema
