# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class JobCity(object):
    _types = {
        "city_code": str,
        "zh_name": str,
        "en_name": str,
    }

    def __init__(self, d=None):
        self.city_code: Optional[str] = None
        self.zh_name: Optional[str] = None
        self.en_name: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "JobCityBuilder":
        return JobCityBuilder()


class JobCityBuilder(object):
    def __init__(self) -> None:
        self._job_city = JobCity()

    def city_code(self, city_code: str) -> "JobCityBuilder":
        self._job_city.city_code = city_code
        return self

    def zh_name(self, zh_name: str) -> "JobCityBuilder":
        self._job_city.zh_name = zh_name
        return self

    def en_name(self, en_name: str) -> "JobCityBuilder":
        self._job_city.en_name = en_name
        return self

    def build(self) -> "JobCity":
        return self._job_city
