# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .i18n import I18n
from .job_customized_value import JobCustomizedValue


class JobCustomizedData(object):
    _types = {
        "object_id": str,
        "name": I18n,
        "object_type": int,
        "value": JobCustomizedValue,
    }

    def __init__(self, d=None):
        self.object_id: Optional[str] = None
        self.name: Optional[I18n] = None
        self.object_type: Optional[int] = None
        self.value: Optional[JobCustomizedValue] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "JobCustomizedDataBuilder":
        return JobCustomizedDataBuilder()


class JobCustomizedDataBuilder(object):
    def __init__(self) -> None:
        self._job_customized_data = JobCustomizedData()

    def object_id(self, object_id: str) -> "JobCustomizedDataBuilder":
        self._job_customized_data.object_id = object_id
        return self

    def name(self, name: I18n) -> "JobCustomizedDataBuilder":
        self._job_customized_data.name = name
        return self

    def object_type(self, object_type: int) -> "JobCustomizedDataBuilder":
        self._job_customized_data.object_type = object_type
        return self

    def value(self, value: JobCustomizedValue) -> "JobCustomizedDataBuilder":
        self._job_customized_data.value = value
        return self

    def build(self) -> "JobCustomizedData":
        return self._job_customized_data
