# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class JobManager(object):
    _types = {
        "id": str,
        "recruiter_id": str,
        "hiring_manager_id_list": List[str],
        "assistant_id_list": List[str],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.recruiter_id: Optional[str] = None
        self.hiring_manager_id_list: Optional[List[str]] = None
        self.assistant_id_list: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "JobManagerBuilder":
        return JobManagerBuilder()


class JobManagerBuilder(object):
    def __init__(self) -> None:
        self._job_manager = JobManager()

    def id(self, id: str) -> "JobManagerBuilder":
        self._job_manager.id = id
        return self

    def recruiter_id(self, recruiter_id: str) -> "JobManagerBuilder":
        self._job_manager.recruiter_id = recruiter_id
        return self

    def hiring_manager_id_list(self, hiring_manager_id_list: List[str]) -> "JobManagerBuilder":
        self._job_manager.hiring_manager_id_list = hiring_manager_id_list
        return self

    def assistant_id_list(self, assistant_id_list: List[str]) -> "JobManagerBuilder":
        self._job_manager.assistant_id_list = assistant_id_list
        return self

    def build(self) -> "JobManager":
        return self._job_manager
