# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class JobRecruiter2(object):
    _types = {
        "id": str,
        "recruiter_id": str,
        "hiring_manager_id_list": List[str],
        "assistant_id_list": List[str],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.recruiter_id: Optional[str] = None
        self.hiring_manager_id_list: Optional[List[str]] = None
        self.assistant_id_list: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "JobRecruiter2Builder":
        return JobRecruiter2Builder()


class JobRecruiter2Builder(object):
    def __init__(self) -> None:
        self._job_recruiter2 = JobRecruiter2()

    def id(self, id: str) -> "JobRecruiter2Builder":
        self._job_recruiter2.id = id
        return self

    def recruiter_id(self, recruiter_id: str) -> "JobRecruiter2Builder":
        self._job_recruiter2.recruiter_id = recruiter_id
        return self

    def hiring_manager_id_list(self, hiring_manager_id_list: List[str]) -> "JobRecruiter2Builder":
        self._job_recruiter2.hiring_manager_id_list = hiring_manager_id_list
        return self

    def assistant_id_list(self, assistant_id_list: List[str]) -> "JobRecruiter2Builder":
        self._job_recruiter2.assistant_id_list = assistant_id_list
        return self

    def build(self) -> "JobRecruiter2":
        return self._job_recruiter2
