# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .i18n import I18n
from .job_requirement_customized_value import JobRequirementCustomizedValue


class JobRequirementCustomizedDataDto(object):
    _types = {
        "object_id": str,
        "name": I18n,
        "object_type": int,
        "value": JobRequirementCustomizedValue,
    }

    def __init__(self, d=None):
        self.object_id: Optional[str] = None
        self.name: Optional[I18n] = None
        self.object_type: Optional[int] = None
        self.value: Optional[JobRequirementCustomizedValue] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "JobRequirementCustomizedDataDtoBuilder":
        return JobRequirementCustomizedDataDtoBuilder()


class JobRequirementCustomizedDataDtoBuilder(object):
    def __init__(self) -> None:
        self._job_requirement_customized_data_dto = JobRequirementCustomizedDataDto()

    def object_id(self, object_id: str) -> "JobRequirementCustomizedDataDtoBuilder":
        self._job_requirement_customized_data_dto.object_id = object_id
        return self

    def name(self, name: I18n) -> "JobRequirementCustomizedDataDtoBuilder":
        self._job_requirement_customized_data_dto.name = name
        return self

    def object_type(self, object_type: int) -> "JobRequirementCustomizedDataDtoBuilder":
        self._job_requirement_customized_data_dto.object_type = object_type
        return self

    def value(self, value: JobRequirementCustomizedValue) -> "JobRequirementCustomizedDataDtoBuilder":
        self._job_requirement_customized_data_dto.value = value
        return self

    def build(self) -> "JobRequirementCustomizedDataDto":
        return self._job_requirement_customized_data_dto
