# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .job_requirement_customized_option import JobRequirementCustomizedOption
from .job_requirement_customized_time_range import JobRequirementCustomizedTimeRange


class JobRequirementCustomizedValue(object):
    _types = {
        "content": str,
        "option": JobRequirementCustomizedOption,
        "option_list": List[JobRequirementCustomizedOption],
        "time_range": JobRequirementCustomizedTimeRange,
        "time": str,
        "number": str,
    }

    def __init__(self, d=None):
        self.content: Optional[str] = None
        self.option: Optional[JobRequirementCustomizedOption] = None
        self.option_list: Optional[List[JobRequirementCustomizedOption]] = None
        self.time_range: Optional[JobRequirementCustomizedTimeRange] = None
        self.time: Optional[str] = None
        self.number: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "JobRequirementCustomizedValueBuilder":
        return JobRequirementCustomizedValueBuilder()


class JobRequirementCustomizedValueBuilder(object):
    def __init__(self) -> None:
        self._job_requirement_customized_value = JobRequirementCustomizedValue()

    def content(self, content: str) -> "JobRequirementCustomizedValueBuilder":
        self._job_requirement_customized_value.content = content
        return self

    def option(self, option: JobRequirementCustomizedOption) -> "JobRequirementCustomizedValueBuilder":
        self._job_requirement_customized_value.option = option
        return self

    def option_list(self, option_list: List[JobRequirementCustomizedOption]) -> "JobRequirementCustomizedValueBuilder":
        self._job_requirement_customized_value.option_list = option_list
        return self

    def time_range(self, time_range: JobRequirementCustomizedTimeRange) -> "JobRequirementCustomizedValueBuilder":
        self._job_requirement_customized_value.time_range = time_range
        return self

    def time(self, time: str) -> "JobRequirementCustomizedValueBuilder":
        self._job_requirement_customized_value.time = time
        return self

    def number(self, number: str) -> "JobRequirementCustomizedValueBuilder":
        self._job_requirement_customized_value.number = number
        return self

    def build(self) -> "JobRequirementCustomizedValue":
        return self._job_requirement_customized_value
