# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .common_schema import CommonSchema
from .i18n import I18n


class JobSchema(object):
    _types = {
        "id": str,
        "name": I18n,
        "scenario_type": int,
        "object_list": List[CommonSchema],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[I18n] = None
        self.scenario_type: Optional[int] = None
        self.object_list: Optional[List[CommonSchema]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "JobSchemaBuilder":
        return JobSchemaBuilder()


class JobSchemaBuilder(object):
    def __init__(self) -> None:
        self._job_schema = JobSchema()

    def id(self, id: str) -> "JobSchemaBuilder":
        self._job_schema.id = id
        return self

    def name(self, name: I18n) -> "JobSchemaBuilder":
        self._job_schema.name = name
        return self

    def scenario_type(self, scenario_type: int) -> "JobSchemaBuilder":
        self._job_schema.scenario_type = scenario_type
        return self

    def object_list(self, object_list: List[CommonSchema]) -> "JobSchemaBuilder":
        self._job_schema.object_list = object_list
        return self

    def build(self) -> "JobSchema":
        return self._job_schema
