# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .i18n import I18n


class JobTypeInfo(object):
    _types = {
        "id": str,
        "name": I18n,
        "parent_id": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[I18n] = None
        self.parent_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "JobTypeInfoBuilder":
        return JobTypeInfoBuilder()


class JobTypeInfoBuilder(object):
    def __init__(self) -> None:
        self._job_type_info = JobTypeInfo()

    def id(self, id: str) -> "JobTypeInfoBuilder":
        self._job_type_info.id = id
        return self

    def name(self, name: I18n) -> "JobTypeInfoBuilder":
        self._job_type_info.name = name
        return self

    def parent_id(self, parent_id: str) -> "JobTypeInfoBuilder":
        self._job_type_info.parent_id = parent_id
        return self

    def build(self) -> "JobTypeInfo":
        return self._job_type_info
