# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .job_processes import JobProcesses


class ListJobProcessResponseBody(object):
    _types = {
        "has_more": bool,
        "page_token": str,
        "items": List[JobProcesses],
    }

    def __init__(self, d=None):
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        self.items: Optional[List[JobProcesses]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListJobProcessResponseBodyBuilder":
        return ListJobProcessResponseBodyBuilder()


class ListJobProcessResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_job_process_response_body = ListJobProcessResponseBody()

    def has_more(self, has_more: bool) -> "ListJobProcessResponseBodyBuilder":
        self._list_job_process_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListJobProcessResponseBodyBuilder":
        self._list_job_process_response_body.page_token = page_token
        return self

    def items(self, items: List[JobProcesses]) -> "ListJobProcessResponseBodyBuilder":
        self._list_job_process_response_body.items = items
        return self

    def build(self) -> "ListJobProcessResponseBody":
        return self._list_job_process_response_body
