# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListJobRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.update_start_time: Optional[int] = None
        self.update_end_time: Optional[int] = None
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.department_id_type: Optional[str] = None
        self.job_level_id_type: Optional[str] = None
        self.job_family_id_type: Optional[str] = None

    @staticmethod
    def builder() -> "ListJobRequestBuilder":
        return ListJobRequestBuilder()


class ListJobRequestBuilder(object):

    def __init__(self) -> None:
        list_job_request = ListJobRequest()
        list_job_request.http_method = HttpMethod.GET
        list_job_request.uri = "/open-apis/hire/v1/jobs"
        list_job_request.token_types = {AccessTokenType.TENANT}
        self._list_job_request: ListJobRequest = list_job_request

    def update_start_time(self, update_start_time: int) -> "ListJobRequestBuilder":
        self._list_job_request.update_start_time = update_start_time
        self._list_job_request.add_query("update_start_time", update_start_time)
        return self

    def update_end_time(self, update_end_time: int) -> "ListJobRequestBuilder":
        self._list_job_request.update_end_time = update_end_time
        self._list_job_request.add_query("update_end_time", update_end_time)
        return self

    def page_size(self, page_size: int) -> "ListJobRequestBuilder":
        self._list_job_request.page_size = page_size
        self._list_job_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListJobRequestBuilder":
        self._list_job_request.page_token = page_token
        self._list_job_request.add_query("page_token", page_token)
        return self

    def user_id_type(self, user_id_type: str) -> "ListJobRequestBuilder":
        self._list_job_request.user_id_type = user_id_type
        self._list_job_request.add_query("user_id_type", user_id_type)
        return self

    def department_id_type(self, department_id_type: str) -> "ListJobRequestBuilder":
        self._list_job_request.department_id_type = department_id_type
        self._list_job_request.add_query("department_id_type", department_id_type)
        return self

    def job_level_id_type(self, job_level_id_type: str) -> "ListJobRequestBuilder":
        self._list_job_request.job_level_id_type = job_level_id_type
        self._list_job_request.add_query("job_level_id_type", job_level_id_type)
        return self

    def job_family_id_type(self, job_family_id_type: str) -> "ListJobRequestBuilder":
        self._list_job_request.job_family_id_type = job_family_id_type
        self._list_job_request.add_query("job_family_id_type", job_family_id_type)
        return self

    def build(self) -> ListJobRequest:
        return self._list_job_request
