# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListJobTypeRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None

    @staticmethod
    def builder() -> "ListJobTypeRequestBuilder":
        return ListJobTypeRequestBuilder()


class ListJobTypeRequestBuilder(object):

    def __init__(self) -> None:
        list_job_type_request = ListJobTypeRequest()
        list_job_type_request.http_method = HttpMethod.GET
        list_job_type_request.uri = "/open-apis/hire/v1/job_types"
        list_job_type_request.token_types = {AccessTokenType.TENANT}
        self._list_job_type_request: ListJobTypeRequest = list_job_type_request

    def page_size(self, page_size: int) -> "ListJobTypeRequestBuilder":
        self._list_job_type_request.page_size = page_size
        self._list_job_type_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListJobTypeRequestBuilder":
        self._list_job_type_request.page_token = page_token
        self._list_job_type_request.add_query("page_token", page_token)
        return self

    def build(self) -> ListJobTypeRequest:
        return self._list_job_type_request
