# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .job_type_info import JobTypeInfo


class ListJobTypeResponseBody(object):
    _types = {
        "items": List[JobTypeInfo],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[JobTypeInfo]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListJobTypeResponseBodyBuilder":
        return ListJobTypeResponseBodyBuilder()


class ListJobTypeResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_job_type_response_body = ListJobTypeResponseBody()

    def items(self, items: List[JobTypeInfo]) -> "ListJobTypeResponseBodyBuilder":
        self._list_job_type_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "ListJobTypeResponseBodyBuilder":
        self._list_job_type_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListJobTypeResponseBodyBuilder":
        self._list_job_type_response_body.has_more = has_more
        return self

    def build(self) -> "ListJobTypeResponseBody":
        return self._list_job_type_response_body
