# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .offer_list_info import OfferListInfo


class ListOfferResponseBody(object):
    _types = {
        "has_more": bool,
        "page_token": str,
        "items": List[OfferListInfo],
    }

    def __init__(self, d=None):
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        self.items: Optional[List[OfferListInfo]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListOfferResponseBodyBuilder":
        return ListOfferResponseBodyBuilder()


class ListOfferResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_offer_response_body = ListOfferResponseBody()

    def has_more(self, has_more: bool) -> "ListOfferResponseBodyBuilder":
        self._list_offer_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListOfferResponseBodyBuilder":
        self._list_offer_response_body.page_token = page_token
        return self

    def items(self, items: List[OfferListInfo]) -> "ListOfferResponseBodyBuilder":
        self._list_offer_response_body.items = items
        return self

    def build(self) -> "ListOfferResponseBody":
        return self._list_offer_response_body
