# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListQuestionnaireRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_token: Optional[str] = None
        self.page_size: Optional[int] = None
        self.application_id: Optional[str] = None
        self.interview_id: Optional[str] = None
        self.update_start_time: Optional[str] = None
        self.update_end_time: Optional[str] = None

    @staticmethod
    def builder() -> "ListQuestionnaireRequestBuilder":
        return ListQuestionnaireRequestBuilder()


class ListQuestionnaireRequestBuilder(object):

    def __init__(self) -> None:
        list_questionnaire_request = ListQuestionnaireRequest()
        list_questionnaire_request.http_method = HttpMethod.GET
        list_questionnaire_request.uri = "/open-apis/hire/v1/questionnaires"
        list_questionnaire_request.token_types = {AccessTokenType.TENANT}
        self._list_questionnaire_request: ListQuestionnaireRequest = list_questionnaire_request

    def page_token(self, page_token: str) -> "ListQuestionnaireRequestBuilder":
        self._list_questionnaire_request.page_token = page_token
        self._list_questionnaire_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: int) -> "ListQuestionnaireRequestBuilder":
        self._list_questionnaire_request.page_size = page_size
        self._list_questionnaire_request.add_query("page_size", page_size)
        return self

    def application_id(self, application_id: str) -> "ListQuestionnaireRequestBuilder":
        self._list_questionnaire_request.application_id = application_id
        self._list_questionnaire_request.add_query("application_id", application_id)
        return self

    def interview_id(self, interview_id: str) -> "ListQuestionnaireRequestBuilder":
        self._list_questionnaire_request.interview_id = interview_id
        self._list_questionnaire_request.add_query("interview_id", interview_id)
        return self

    def update_start_time(self, update_start_time: str) -> "ListQuestionnaireRequestBuilder":
        self._list_questionnaire_request.update_start_time = update_start_time
        self._list_questionnaire_request.add_query("update_start_time", update_start_time)
        return self

    def update_end_time(self, update_end_time: str) -> "ListQuestionnaireRequestBuilder":
        self._list_questionnaire_request.update_end_time = update_end_time
        self._list_questionnaire_request.add_query("update_end_time", update_end_time)
        return self

    def build(self) -> ListQuestionnaireRequest:
        return self._list_questionnaire_request
