# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .questionnaire import Questionnaire


class ListQuestionnaireResponseBody(object):
    _types = {
        "has_more": bool,
        "page_token": str,
        "items": List[Questionnaire],
    }

    def __init__(self, d=None):
        self.has_more: Optional[bool] = None
        self.page_token: Optional[str] = None
        self.items: Optional[List[Questionnaire]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListQuestionnaireResponseBodyBuilder":
        return ListQuestionnaireResponseBodyBuilder()


class ListQuestionnaireResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_questionnaire_response_body = ListQuestionnaireResponseBody()

    def has_more(self, has_more: bool) -> "ListQuestionnaireResponseBodyBuilder":
        self._list_questionnaire_response_body.has_more = has_more
        return self

    def page_token(self, page_token: str) -> "ListQuestionnaireResponseBodyBuilder":
        self._list_questionnaire_response_body.page_token = page_token
        return self

    def items(self, items: List[Questionnaire]) -> "ListQuestionnaireResponseBodyBuilder":
        self._list_questionnaire_response_body.items = items
        return self

    def build(self) -> "ListQuestionnaireResponseBody":
        return self._list_questionnaire_response_body
