# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListReferralWebsiteJobPostRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.process_type: Optional[int] = None
        self.page_token: Optional[str] = None
        self.page_size: Optional[int] = None
        self.user_id_type: Optional[str] = None
        self.department_id_type: Optional[str] = None
        self.job_level_id_type: Optional[str] = None

    @staticmethod
    def builder() -> "ListReferralWebsiteJobPostRequestBuilder":
        return ListReferralWebsiteJobPostRequestBuilder()


class ListReferralWebsiteJobPostRequestBuilder(object):

    def __init__(self) -> None:
        list_referral_website_job_post_request = ListReferralWebsiteJobPostRequest()
        list_referral_website_job_post_request.http_method = HttpMethod.GET
        list_referral_website_job_post_request.uri = "/open-apis/hire/v1/referral_websites/job_posts"
        list_referral_website_job_post_request.token_types = {AccessTokenType.TENANT}
        self._list_referral_website_job_post_request: ListReferralWebsiteJobPostRequest = list_referral_website_job_post_request

    def process_type(self, process_type: int) -> "ListReferralWebsiteJobPostRequestBuilder":
        self._list_referral_website_job_post_request.process_type = process_type
        self._list_referral_website_job_post_request.add_query("process_type", process_type)
        return self

    def page_token(self, page_token: str) -> "ListReferralWebsiteJobPostRequestBuilder":
        self._list_referral_website_job_post_request.page_token = page_token
        self._list_referral_website_job_post_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: int) -> "ListReferralWebsiteJobPostRequestBuilder":
        self._list_referral_website_job_post_request.page_size = page_size
        self._list_referral_website_job_post_request.add_query("page_size", page_size)
        return self

    def user_id_type(self, user_id_type: str) -> "ListReferralWebsiteJobPostRequestBuilder":
        self._list_referral_website_job_post_request.user_id_type = user_id_type
        self._list_referral_website_job_post_request.add_query("user_id_type", user_id_type)
        return self

    def department_id_type(self, department_id_type: str) -> "ListReferralWebsiteJobPostRequestBuilder":
        self._list_referral_website_job_post_request.department_id_type = department_id_type
        self._list_referral_website_job_post_request.add_query("department_id_type", department_id_type)
        return self

    def job_level_id_type(self, job_level_id_type: str) -> "ListReferralWebsiteJobPostRequestBuilder":
        self._list_referral_website_job_post_request.job_level_id_type = job_level_id_type
        self._list_referral_website_job_post_request.add_query("job_level_id_type", job_level_id_type)
        return self

    def build(self) -> ListReferralWebsiteJobPostRequest:
        return self._list_referral_website_job_post_request
