# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .login_info_eco_exam_request_body import LoginInfoEcoExamRequestBody


class LoginInfoEcoExamRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.exam_id: Optional[str] = None
        self.request_body: Optional[LoginInfoEcoExamRequestBody] = None

    @staticmethod
    def builder() -> "LoginInfoEcoExamRequestBuilder":
        return LoginInfoEcoExamRequestBuilder()


class LoginInfoEcoExamRequestBuilder(object):

    def __init__(self) -> None:
        login_info_eco_exam_request = LoginInfoEcoExamRequest()
        login_info_eco_exam_request.http_method = HttpMethod.POST
        login_info_eco_exam_request.uri = "/open-apis/hire/v1/eco_exams/:exam_id/login_info"
        login_info_eco_exam_request.token_types = {AccessTokenType.TENANT}
        self._login_info_eco_exam_request: LoginInfoEcoExamRequest = login_info_eco_exam_request

    def exam_id(self, exam_id: str) -> "LoginInfoEcoExamRequestBuilder":
        self._login_info_eco_exam_request.exam_id = exam_id
        self._login_info_eco_exam_request.paths["exam_id"] = str(exam_id)
        return self

    def request_body(self, request_body: LoginInfoEcoExamRequestBody) -> "LoginInfoEcoExamRequestBuilder":
        self._login_info_eco_exam_request.request_body = request_body
        self._login_info_eco_exam_request.body = request_body
        return self

    def build(self) -> LoginInfoEcoExamRequest:
        return self._login_info_eco_exam_request
