# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .i18n import I18n
from .offer_apply_form_schema import OfferApplyFormSchema


class OfferApplyFormInfo(object):
    _types = {
        "id": str,
        "name": I18n,
        "schema": OfferApplyFormSchema,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[I18n] = None
        self.schema: Optional[OfferApplyFormSchema] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OfferApplyFormInfoBuilder":
        return OfferApplyFormInfoBuilder()


class OfferApplyFormInfoBuilder(object):
    def __init__(self) -> None:
        self._offer_apply_form_info = OfferApplyFormInfo()

    def id(self, id: str) -> "OfferApplyFormInfoBuilder":
        self._offer_apply_form_info.id = id
        return self

    def name(self, name: I18n) -> "OfferApplyFormInfoBuilder":
        self._offer_apply_form_info.name = name
        return self

    def schema(self, schema: OfferApplyFormSchema) -> "OfferApplyFormInfoBuilder":
        self._offer_apply_form_info.schema = schema
        return self

    def build(self) -> "OfferApplyFormInfo":
        return self._offer_apply_form_info
